<?php

class Text_book extends Eloquent {

	protected $table = 'Text_Book';
	public $timestamps = true;
	protected $fillable = array('subject_id', 'education_level_id', 'title', 'total_quantity', 'sold_quantity', 'price', 'available_quantity');
	protected $visible = array('subject_id', 'education_level_id', 'title', 'total_quantity', 'sold_quantity', 'price', 'available_quantity');

	public function EducationLevel()
	{
		return $this->belongsTo('Education_level', 'education_level_id');
	}

	public function sales()
	{
		return $this->hasMany('Student_textbook_sale', 'textbook_id');
	}

	public function subject()
	{
		return $this->belongsTo('Subject', 'subject_id');
	}

}