<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Student_profile extends Model 
{

    protected $table = 'Student_Profile';
    public $timestamps = true;
    protected $fillable = array('student_id', 'education_level_id', 'total_absences', 'unexcused_absences', 'score', 'behavior_notes', 'health_notes', 'interests', 'activities_participated', 'achievements', 'guardian_feedback', 'teacher_feedback', 'skills');
    protected $visible = array('student_id', 'education_level_id', 'total_absences', 'unexcused_absences', 'score', 'behavior_notes', 'health_notes', 'interests', 'activities_participated', 'achievements', 'guardian_feedback', 'teacher_feedback', 'skills');

    public function student()
    {
        return $this->belongsTo('Student', 'student_id');
    }

    public function education_level()
    {
        return $this->belongsTo('Education_level', 'education_level_id');
    }

}