<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStaffLeavesTable extends Migration {

	public function up()
	{
		Schema::create('Staff_leaves', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->date('start_date');
			$table->date('End_date');
			$table->enum('leave_type', array('sick', 'personal', 'unpaid', 'emergency'));
			$table->enum('status', array('pending', 'approved', 'rejected'));
			$table->text('notes')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('Staff_leaves');
	}
}