<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSalaryTable extends Migration {

	public function up()
	{
		Schema::create('Salary', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->decimal('Base_salary');
			$table->decimal('bonus')->nullable();
			$table->decimal('deductions')->nullable();
			$table->date('date');
			$table->enum('status', array('paid', 'pending'));
			$table->text('notes')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('Salary');
	}
}