<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTransactionTable extends Migration {

	public function up()
	{
		Schema::create('Transaction', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->enum('payment_method', array('cash', 'visa', 'Transfer(shamcash)'));
			$table->decimal('amount');
			$table->enum('type', array('in', 'out'));
			$table->enum('transaction_source', array('salary', 'buy_book', 'register_user', 'activity'));
			$table->enum('status', array('pending', 'paid', 'failed'));
			$table->integer('installment_number')->nullable();
			$table->string('payment_reference');
			$table->boolean('is_installment');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('Transaction');
	}
}