<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCoursesTable extends Migration {

	public function up()
	{
		Schema::create('courses', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('course_type_id')->unsigned()->nullable();
			$table->string('code', 20)->nullable();
			$table->string('acronym', 20)->nullable();
			$table->integer('director')->nullable();
			$table->integer('assistant_director')->nullable();
			$table->integer('assistant_director2')->nullable();
			$table->text('address')->nullable();
			$table->string('phone')->nullable();
			$table->string('phone2')->nullable();
			$table->string('fax')->nullable();
			$table->string('email')->nullable();
			$table->string('url')->nullable();
			$table->string('image')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('courses');
	}
}