<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Course extends Eloquent {

	protected $table = 'courses';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('course_type_id', 'code', 'acronym', 'director', 'assistant_director', 'assistant_director2', 'address', 'phone', 'phone2', 'fax', 'email', 'url', 'image');
	protected $visible = array('course_type_id', 'code', 'acronym', 'director', 'assistant_director', 'assistant_director2', 'address', 'phone', 'phone2', 'fax', 'email', 'url', 'image');

	public function type()
	{
		return $this->belongsTo('CourseType');
	}

	public function texts()
	{
		return $this->morphMany('Text', 'textable');
	}

	public function detail()
	{
		return $this->hasMany('CourseDetail');
	}

	public function units()
	{
		return $this->belongsToMany('Unit')->withPivot('year_id', 'schedule_id', 'credits_ects');
	}

}