<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Staff extends Model 
{

    protected $table = 'staff';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('staff_type_id', 'name', 'phone', 'phone_extension', 'email', 'url', 'image');
    protected $visible = array('staff_type_id', 'name', 'phone', 'phone_extension', 'email', 'url', 'image');

    public function type()
    {
        return $this->belongsTo('StaffType');
    }

    public function units()
    {
        return $this->belongsToMany('Unit');
    }

}