<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomAttributesTable extends Migration {

	public function up()
	{
		Schema::create('custom_attributes', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('field_name', 255)->index();
			$table->string('field_value', 255)->index();
			$table->string('field_type', 255)->index();
			$table->string('field_label', 255);
			$table->boolean('required')->index()->default(0);
		});
	}

	public function down()
	{
		Schema::drop('custom_attributes');
	}
}