<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCoupenTable extends Migration {

	public function up()
	{
		Schema::create('coupen', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->double('amount');
			$table->string('description', 255);
			$table->string('image', 255)->nullable();
			$table->datetime('start_date');
			$table->datetime('end_date');
			$table->integer('status');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('coupen');
	}
}