<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('category_id')->unsigned()->index();
			$table->string('categorietree', 255);
			$table->string('name', 255);
			$table->string('description', 255);
			$table->double('price')->index();
			$table->double('offerprice')->index();
			$table->enum('status', array('Pending', 'Approved', 'Declined'))->index();
			$table->string('approvel_note', 255)->nullable();
			$table->integer('user_id')->unsigned();
			$table->integer('store_id')->unsigned();
			$table->string('location_lat', 255)->nullable();
			$table->string('location_long', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}