<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAddressBookTable extends Migration {

	public function up()
	{
		Schema::create('address_book', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->string('lat', 255)->nullable();
			$table->string('long', 255)->nullable();
			$table->integer('user_id');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('address_book');
	}
}