<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->string('email', 255);
			$table->string('phone', 50);
			$table->integer('role');
			$table->integer('status');
			$table->datetime('last_login');
			$table->enum('email_verify_status', array('Pending', 'Verified'))->nullable();
			$table->enum('phone_verify_status', array('Pending', 'Verified'))->nullable();
			$table->string('api_token', 255)->nullable();
			$table->string('password', 255);
			$table->string('profilePic', 255)->nullable();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}