<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('empresas', function(Blueprint $table) {
			$table->foreign('seguimento_id')->references('id')->on('seguimentos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('produtos', function(Blueprint $table) {
			$table->foreign('empresa_id')->references('id')->on('empresas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('pedidos', function(Blueprint $table) {
			$table->foreign('empresa_id')->references('id')->on('empresas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('pedidos', function(Blueprint $table) {
			$table->foreign('produto_id')->references('id')->on('produtos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('empresas', function(Blueprint $table) {
			$table->dropForeign('empresas_seguimento_id_foreign');
		});
		Schema::table('produtos', function(Blueprint $table) {
			$table->dropForeign('produtos_empresa_id_foreign');
		});
		Schema::table('pedidos', function(Blueprint $table) {
			$table->dropForeign('pedidos_empresa_id_foreign');
		});
		Schema::table('pedidos', function(Blueprint $table) {
			$table->dropForeign('pedidos_produto_id_foreign');
		});
	}
}