<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function plan()
    {
        return $this->belongsTo('Plan');
    }

    public function records()
    {
        return $this->belongsToMany('PersonalRecord');
    }

    public function workouts()
    {
        return $this->belongsToMany('Workout')is_complete;
    }

    public function avatar()
    {
        return $this->belongsTo('Avatar');
    }

}