<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Workout extends Model 
{

    protected $table = 'workouts';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function exercises()
    {
        return $this->belongsToMany('Exercise');
    }

    public function comments()
    {
        return $this->hasMany('WorkoutComment');
    }

}