<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePersonalRecordsTable extends Migration {

	public function up()
	{
		Schema::create('personal_records', function(Blueprint $table) {
			$table->increments('id');
			$table->bigIncrements('user_id');
			$table->string('name');
			$table->decimal('value');
			$table->tinyInteger('is_complete')->default('0');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('personal_records');
	}
}