<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function plan()
	{
		return $this->belongsTo('Plan');
	}

	public function records()
	{
		return $this->belongsToMany('PersonalRecord');
	}

	public function workouts()
	{
		return $this->belongsToMany('Workout')is_complete;
	}

	public function avatar()
	{
		return $this->belongsTo('Avatar');
	}

}