<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Workout extends Eloquent {

	protected $table = 'workouts';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function exercises()
	{
		return $this->belongsToMany('Exercise');
	}

	public function comments()
	{
		return $this->hasMany('WorkoutComment');
	}

}