<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCasesTable extends Migration {

	public function up()
	{
		Schema::create('cases', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title', 255);
			$table->string('address', 255);
			$table->string('image', 255);
			$table->integer('user_id')->unsigned();
			$table->integer('cat_id')->unsigned();
			$table->integer('approval')->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('cases');
	}
}