<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Quotation extends Model 
{

    protected $table = 'quotation';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('order_id', 'date', 'status', 'total', 'tax', 'total_with_tax');

    public function order()
    {
        return $this->belongsTo('SpareOrder', 'order_id');
    }

}