<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MaintenanceOrder extends Model 
{

    protected $table = 'maintenance_order';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('region_id', 'date', 'site_id', 'details', 'status', 'type_id');

    public function region()
    {
        return $this->belongsTo('Region', 'region_id');
    }

    public function site()
    {
        return $this->belongsTo('Site', 'site_id');
    }

    public function type()
    {
        return $this->belongsTo('MaintenanceType', 'type_id');
    }

}