<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class QuotationItem extends Model 
{

    protected $table = 'quotation_item';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('quotation_id', 'item_name', 'amount', 'unit_id', 'unit_price', 'total_price', 'notes');

    public function unit()
    {
        return $this->belongsTo('Unit', 'unit_id');
    }

    public function quotation()
    {
        return $this->belongsTo('Quotation', 'quotation_id');
    }

}