<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SpareOrder extends Model 
{

    protected $table = 'spare_order';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('order_id', 'date', 'status', 'quotation_id');

    public function order()
    {
        return $this->belongsTo('MaintenanceOrder', 'order_id');
    }

    public function quotation()
    {
        return $this->belongsTo('Quotation', 'quotation_id');
    }

}