<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInventoryHistoryTable extends Migration {

	public function up()
	{
		Schema::create('inventory_history', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('inventory_id')->nullable();
			$table->integer('item_id')->nullable();
			$table->integer('quantity')->nullable();
			$table->text('notes')->nullable();
			$table->string('type')->nullable();
			$table->string('process_type')->nullable();
			$table->datetime('date')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('inventory_history');
	}
}