<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQuotationItemTable extends Migration {

	public function up()
	{
		Schema::create('quotation_item', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('quotation_id')->nullable();
			$table->string('item_name')->nullable();
			$table->integer('amount')->nullable();
			$table->integer('unit_id')->nullable();
			$table->double('unit_price')->nullable();
			$table->double('total_price')->nullable();
			$table->text('notes')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('quotation_item');
	}
}