<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class MaintenanceHistory extends Eloquent {

	protected $table = 'maintenance_history';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('order_id', 'date', 'details', 'user_id');

	public function order()
	{
		return $this->belongsTo('MaintenanceOrder', 'order_id');
	}

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

}