<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Region extends Eloquent {

	protected $table = 'region';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name_en', 'name_ar', 'officer_id', 'employee_id');

	public function employee()
	{
		return $this->belongsTo('User', 'employee_id');
	}

	public function officer()
	{
		return $this->belongsTo('User', 'officer_id');
	}

}