<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInventoryTable extends Migration {

	public function up()
	{
		Schema::create('inventory', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('region_id')->nullable();
			$table->integer('item_id')->nullable();
			$table->integer('quantity')->nullable();
			$table->text('notes')->nullable();
			$table->integer('site_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('inventory');
	}
}