<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class AchievementCertificate extends Eloquent {

	protected $table = 'achievement_certificate';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('region_id', 'date_from', 'date_to', 'total', 'date', 'status');

	public function region()
	{
		return $this->belongsTo('Region', 'region_id');
	}

}