<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class AchievementValue extends Eloquent {

	protected $table = 'achievement_value';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('item_id', 'percentage', 'notes', 'achievement_id');

	public function achievement()
	{
		return $this->belongsTo('AchievementCertificate', 'achievement_id');
	}

	public function item()
	{
		return $this->belongsTo('AchievementItem', 'item_id');
	}

}