<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class File extends Eloquent {

	protected $table = 'file';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('category_id', 'title_en', 'title_ar');

	public function category()
	{
		return $this->belongsTo('FileCategory', 'category_id');
	}

}