<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class InventoryRecord extends Eloquent {

	protected $table = 'inventory_record';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('date', 'region_id', 'site_id');

	public function site()
	{
		return $this->belongsTo('Site', 'site_id');
	}

	public function region()
	{
		return $this->belongsTo('Region', 'region_id');
	}

}