<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Quotation extends Eloquent {

	protected $table = 'quotation';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('order_id', 'date', 'status', 'total', 'tax', 'total_with_tax');

	public function order()
	{
		return $this->belongsTo('SpareOrder', 'order_id');
	}

}