<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class QuotationItem extends Eloquent {

	protected $table = 'quotation_item';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('quotation_id', 'item_name', 'amount', 'unit_id', 'unit_price', 'total_price', 'notes');

	public function unit()
	{
		return $this->belongsTo('Unit', 'unit_id');
	}

	public function quotation()
	{
		return $this->belongsTo('Quotation', 'quotation_id');
	}

}