<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQuotationTable extends Migration {

	public function up()
	{
		Schema::create('quotation', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('order_id')->nullable();
			$table->datetime('date')->nullable();
			$table->string('status')->nullable();
			$table->double('total')->nullable();
			$table->double('tax')->nullable();
			$table->double('total_with_tax')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('quotation');
	}
}