<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTabBuyerAddressTable extends Migration {

	public function up()
	{
		Schema::create('tabBuyerAddress', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('buyer_id')->unsigned();
			$table->string('name');
			$table->string('type');
			$table->text('address');
			$table->string('landmark')->nullable();
			$table->string('city');
			$table->string('state');
			$table->string('country');
			$table->string('post_code');
			$table->string('contact_no');
			$table->string('owner');
			$table->string('last_updated_by');
			$table->timestamp('created_at');
			$table->timestamp('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('tabBuyerAddress');
	}
}