<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTabCouponTable extends Migration {

	public function up()
	{
		Schema::create('tabCoupon', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('status')->default('Active');
			$table->integer('seller_id')->unsigned();
			$table->integer('total_coupons');
			$table->integer('total_redeemed')->default('0');
			$table->datetime('valid_from');
			$table->datetime('valid_till');
			$table->string('coupon_type');
			$table->string('discount_method');
			$table->decimal('discount_amount', 10,2);
			$table->decimal('minimum_purchase', 10,2);
			$table->string('discount_on');
			$table->text('description')->nullable();
			$table->string('owner');
			$table->string('last_updated_by');
			$table->timestamp('created_at');
			$table->timestamp('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('tabCoupon');
	}
}