<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTabBuyerTable extends Migration {

	public function up()
	{
		Schema::create('tabBuyer', function(Blueprint $table) {
			$table->increments('id');
			$table->string('avatar')->nullable();
			$table->string('title');
			$table->string('name');
			$table->date('dob')->nullable();
			$table->string('gender');
			$table->string('email_id');
			$table->string('contact_no')->nullable();
			$table->string('preferred_language');
			$table->decimal('lifetime_value', 10,2)->nullable();
			$table->integer('total_orders');
			$table->string('owner');
			$table->string('last_updated_by');
			$table->timestamp('created_at');
			$table->timestamp('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('tabBuyer');
	}
}