<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTabCategoryTable extends Migration {

	public function up()
	{
		Schema::create('tabCategory', function(Blueprint $table) {
			$table->increments('id');
			$table->string('avatar')->nullable();
			$table->string('name');
			$table->string('status')->default('Active');
			$table->integer('parent_id')->nullable();
			$table->string('parent_category')->nullable();
			$table->string('slug');
			$table->boolean('show_on_home_page')->default(0);
			$table->string('owner');
			$table->string('last_updated_by');
			$table->timestamp('created_at');
			$table->timestamp('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('tabCategory');
	}
}