<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTabUserTable extends Migration {

	public function up()
	{
		Schema::create('tabUser', function(Blueprint $table) {
			$table->increments('id');
			$table->string('full_name');
			$table->string('avatar')->nullable();
			$table->string('login_id')->unique();
			$table->string('password');
			$table->string('email')->unique();
			$table->string('role');
			$table->string('status');
			$table->tinyInteger('email_confirmed')->default('0');
			$table->string('email_confirmation_code')->nullable();
			$table->tinyInteger('first_login')->default('0');
			$table->string('owner');
			$table->string('last_updated_by');
			$table->timestamp('created_at');
			$table->timestamp('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('tabUser');
	}
}