<?php

namespace MyTerroir;

class Order extends Eloquent {

	protected $table = 'tabOrder';
	public $timestamps = false;
	protected $fillable = array('seller_id', 'order_status');

	public function getOrderTaxes()
	{
		return $this->hasMany('MyTerroir\OrderTax', 'order_id');
	}

	public function getOrderProducts()
	{
		return $this->hasMany('MyTerroir\OrderDetails', 'order_id');
	}

	public function getOrderStatuses()
	{
		return $this->hasMany('MyTerroir\OrderStatus', 'order_id');
	}

	public function getOrderBuyer()
	{
		return $this->belongsTo('MyTerroir\Buyer', 'buyer_id');
	}

}