<?php

namespace MyTerroir;

use Illuminate\Database\Eloquent\Model;

class Product extends Model 
{

    protected $table = 'tabProduct';
    public $timestamps = false;
    protected $fillable = array('avatar', 'status', 'type', 'seller_id', 'region_id', 'category_id', 'starting_price', 'sku', 'unit_id', 'qty', 'max_order_qty', 'inactive_till', 'variant_product', 'customization', 'combo_product', 'meta_title', 'meta_keywords', 'meta_description', 'slug', 'seller_commission', 'description', 'owner', 'last_updated_by', 'created_at', 'updated_at');

    public function getProductCombo()
    {
        return $this->hasMany('ProductCombo', 'product_id');
    }

    public function getProductCustomization()
    {
        return $this->hasMany('ProductCustomization', 'product_id');
    }

    public function getProductVariant()
    {
        return $this->hasMany('ProductVariant', 'product_id');
    }

    public function getRelatedProducts()
    {
        return $this->hasMany('ProductRelated', 'product_id');
    }

    public function getProductComments()
    {
        return $this->hasMany('ProductComments', 'product_id');
    }

    public function getProductImages()
    {
        return $this->hasMany('ProductImages', 'product_id');
    }

}