<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTabProductTable extends Migration {

	public function up()
	{
		Schema::create('tabProduct', function(Blueprint $table) {
			$table->increments('id');
			$table->string('avatar')->nullable();
			$table->string('name');
			$table->string('status');
			$table->string('type');
			$table->integer('seller_id')->unsigned();
			$table->integer('region_id')->unsigned();
			$table->integer('category_id')->unsigned();
			$table->decimal('starting_price', 10,2);
			$table->string('sku')->nullable();
			$table->integer('unit_id')->unsigned();
			$table->decimal('qty', 10,2);
			$table->decimal('max_order_qty', 10,2)->nullable();
			$table->datetime('inactive_till')->nullable();
			$table->string('variant_product');
			$table->string('customization');
			$table->string('combo_product');
			$table->string('meta_title')->nullable();
			$table->text('meta_keywords')->nullable();
			$table->text('meta_description')->nullable();
			$table->string('slug');
			$table->decimal('seller_commission', 10,2)->nullable();
			$table->text('description')->nullable();
			$table->string('owner');
			$table->string('last_updated_by');
			$table->timestamp('created_at');
			$table->timestamp('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('tabProduct');
	}
}