<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderMealTable extends Migration {

	public function up()
	{
		Schema::create('order_meal', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('order_id')->unsigned();
			$table->integer('meal_id')->unsigned();
			$table->decimal('price');
			$table->integer('qty');
			$table->text('note')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('order_meal');
	}
}