<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDistrictsTable extends Migration {

	public function up()
	{
		Schema::create('districts', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->boolean('is_active')->default(true);
			$table->integer('city_id')->unsigned();
			$table->integer('country_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('districts');
	}
}