<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdminsTable extends Migration {

	public function up()
	{
		Schema::create('admins', function(Blueprint $table) {
			$table->increments('id');
			$table->string('full_name')->nullable();
			$table->string('phone', 20)->nullable();
			$table->string('email')->nullable();
			$table->string('password')->nullable();
			$table->boolean('is_active')->default(true);
			$table->string('address')->nullable();
			$table->string('national_id')->nullable();
			$table->integer('country_id')->unsigned();
			$table->integer('nationality_id')->unsigned();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('admins');
	}
}