<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientsTable extends Migration {

	public function up()
	{
		Schema::create('clients', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('phone', 20)->nullable();
			$table->string('email')->nullable();
			$table->string('password')->nullable();
			$table->boolean('is_guest')->default(false);
			$table->string('full_name')->nullable();
			$table->boolean('terms_accepted')->default(true);
			$table->timestamp('phone_verified_at')->nullable();
			$table->timestamp('email_verified_at')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('clients');
	}
}