<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCulturalEntityTypeEmployeesTable extends Migration {

	public function up()
	{
		Schema::create('cultural_entity_type_employees', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('fuii_name')->nullable();
			$table->string('email')->nullable();
			$table->integer('role_id')->unsigned();
			$table->string('phone', 20)->nullable();
			$table->string('national_id')->nullable();
			$table->boolean('is_active')->default(true);
			$table->integer('cultural_entity_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('cultural_entity_type_employees');
	}
}