<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlanDiscountsTable extends Migration {

	public function up()
	{
		Schema::create('plan_discounts', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('subscription_plan_id')->unsigned();
			$table->string('discount_type')->nullable();
			$table->decimal('discount_value');
			$table->string('trigger')->nullable();
			$table->boolean('is_permanent')->default(false);
			$table->date('start_date')->nullable();
			$table->date('end_date')->nullable();
			$table->integer('relative_days')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('plan_discounts');
	}
}